<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Services_Hover_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_services_hover_cards'; }
    public function get_title() { return __('Services Hover Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-flip-box'; }
    public function get_categories() { return array('ai-theme-services'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $repeater->add_control('icon', ['label' => __('Icon', 'ai-theme'), 'type' => Controls_Manager::ICONS]);
        $this->add_control('services', ['label' => __('Services', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-services ai-services-hover-cards bg-[var(--bg-primary)] py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="services" data-block-variant="services-hover-cards">
            <div class="ai-container">
                <div class="text-center mb-12">
                    <h2 class="ai-services-title text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($s['title']); ?></h2>
                </div>
                <div class="ai-services-items grid sm:grid-cols-2 lg:grid-cols-4 gap-4">
                    <?php foreach ($s['services'] as $svc) : ?>
                    <div class="ai-service-card bg-[var(--bg-secondary)] p-5 rounded-xl border border-[var(--border-color)] hover:bg-[var(--bg-tertiary)] hover:border-[var(--border-hover)] transition-all group cursor-pointer">
                        <div class="mb-3 group-hover:scale-110 transition-transform">
                            <?php if (!empty($svc['icon']['value'])) : ?>
                                <i class="<?php echo esc_attr($svc['icon']['value']); ?> text-3xl text-[var(--primary)]"></i>
                            <?php endif; ?>
                        </div>
                        <h3 class="text-base font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($svc['title']); ?></h3>
                        <p class="text-sm text-[var(--text-secondary)] line-clamp-3"><?php echo esc_html($svc['description']); ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
