<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Services_Icons extends AI_Widget_Base {
    public function get_name() { return 'ai_services_icons'; }
    public function get_title() { return __('Services Icons', 'ai-theme'); }
    public function get_icon() { return 'eicon-service-icon'; }
    public function get_categories() { return array('ai-theme-general'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $this->add_control('subheading', array('label' => __('Subheading', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));

        $repeater = new Repeater();
        $repeater->add_control('title', array('label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));
        $repeater->add_control('description', array('label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $repeater->add_control('icon', array('label' => __('Icon', 'ai-theme'), 'type' => Controls_Manager::ICONS));
        $repeater->add_control('link', array('label' => __('Link', 'ai-theme'), 'type' => Controls_Manager::URL));

        $this->add_control('services', array('label' => __('Services', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls(), 'default' => array()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-20 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="services" data-block-variant="services-icons">
            <div class="max-w-6xl mx-auto px-6">
                <div class="text-center mb-12">
                    <?php if (!empty($settings['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-4"><?php echo esc_html($settings['heading']); ?></h2>
                    <?php endif; ?>
                    <?php if (!empty($settings['subheading'])) : ?>
                        <p class="text-lg text-[var(--text-secondary)] max-w-2xl mx-auto"><?php echo esc_html($settings['subheading']); ?></p>
                    <?php endif; ?>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php foreach ($settings['services'] as $service) : ?>
                        <div class="text-center">
                            <div class="w-16 h-16 bg-[var(--primary-light,#dbeafe)] rounded-2xl flex items-center justify-center mx-auto mb-4">
                                <svg class="w-8 h-8 text-[var(--primary)]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/></svg>
                            </div>
                            <h3 class="text-xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($service['title']); ?></h3>
                            <?php if (!empty($service['description'])) : ?>
                                <p class="text-[var(--text-secondary)]"><?php echo esc_html($service['description']); ?></p>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
