<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Services_List extends AI_Widget_Base {
    public function get_name() { return 'ai_services_list'; }
    public function get_title() { return __('Services List', 'ai-theme'); }
    public function get_icon() { return 'eicon-bullet-list'; }
    public function get_categories() { return array('ai-theme-services'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        $this->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);

        $repeater = new Repeater();
        $repeater->add_control('title', ['label' => __('Title', 'ai-theme'), 'type' => Controls_Manager::TEXT]);
        $repeater->add_control('description', ['label' => __('Description', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA]);
        $this->add_control('services', ['label' => __('Services', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()]);
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="ai-services ai-services-list section-secondary py-16" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="services" data-block-variant="services-list">
            <div class="ai-container-narrow">
                <h2 class="ai-services-title text-4xl font-bold text-[var(--text-primary)] mb-12 text-center"><?php echo esc_html($s['title']); ?></h2>
                <div class="ai-services-items space-y-6">
                    <?php foreach ($s['services'] as $svc) : ?>
                    <div class="ai-service-item bg-[var(--bg-primary)] p-6 rounded-xl shadow-sm border border-[var(--border-color,#e5e7eb)] hover:shadow-md transition-all">
                        <h3 class="text-xl font-bold text-[var(--text-primary)] mb-2"><?php echo esc_html($svc['title']); ?></h3>
                        <div class="text-[var(--text-secondary)] prose prose-sm max-w-none"><?php echo wp_kses_post($svc['description']); ?></div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
