<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Team_Showcase_Cards extends AI_Widget_Base {
    public function get_name() { return 'ai_team_showcase_cards'; }
    public function get_title() { return __('Team Showcase Cards', 'ai-theme'); }
    public function get_icon() { return 'eicon-person'; }
    public function get_categories() { return array('ai-theme-team'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('name', array('label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('role', array('label' => __('Role', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('bio', array('label' => __('Bio', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $repeater->add_control('image', array('label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA));

        $this->add_control('members', array('label' => __('Members', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-20 bg-[var(--bg-secondary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="team" data-block-variant="team-showcase-cards">
            <div class="max-w-6xl mx-auto px-6">
                <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] text-center mb-12"><?php echo esc_html($settings['heading']); ?></h2>
                <?php endif; ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php foreach ($settings['members'] as $member) : ?>
                        <div class="bg-[var(--bg-primary)] rounded-[var(--card-radius)] overflow-hidden shadow-[var(--shadow-card)] group">
                            <div class="aspect-[4/3] bg-[var(--bg-tertiary,#e2e8f0)] overflow-hidden">
                                <?php if (!empty($member['image']['url'])) : ?>
                                    <img src="<?php echo esc_url($member['image']['url']); ?>" alt="<?php echo esc_attr($member['name']); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" />
                                <?php endif; ?>
                            </div>
                            <div class="p-6">
                                <h3 class="text-xl font-bold text-[var(--text-primary)]"><?php echo esc_html($member['name']); ?></h3>
                                <p class="text-[var(--primary)] font-medium mb-3"><?php echo esc_html($member['role']); ?></p>
                                <?php if (!empty($member['bio'])) : ?>
                                    <p class="text-sm text-[var(--text-secondary)]"><?php echo esc_html($member['bio']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
