<?php
namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Team_Showcase_Magazine extends AI_Widget_Base {
    public function get_name() { return 'ai_team_showcase_magazine'; }
    public function get_title() { return __('Team Showcase Magazine', 'ai-theme'); }
    public function get_icon() { return 'eicon-person'; }
    public function get_categories() { return array('ai-theme-team'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', array('label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT));
        $this->add_control('heading', array('label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => ''));

        $repeater = new Repeater();
        $repeater->add_control('name', array('label' => __('Name', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('role', array('label' => __('Role', 'ai-theme'), 'type' => Controls_Manager::TEXT));
        $repeater->add_control('bio', array('label' => __('Bio', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));
        $repeater->add_control('image', array('label' => __('Image', 'ai-theme'), 'type' => Controls_Manager::MEDIA));
        $repeater->add_control('quote', array('label' => __('Quote', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA));

        $this->add_control('members', array('label' => __('Members', 'ai-theme'), 'type' => Controls_Manager::REPEATER, 'fields' => $repeater->get_controls()));
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-20 bg-[var(--bg-primary)]" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="team" data-block-variant="team-showcase-magazine">
            <div class="max-w-6xl mx-auto px-6">
                <?php if (!empty($settings['heading'])) : ?>
                    <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)] mb-12"><?php echo esc_html($settings['heading']); ?></h2>
                <?php endif; ?>
                <div class="space-y-16">
                    <?php foreach ($settings['members'] as $idx => $member) : ?>
                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center <?php echo $idx % 2 === 1 ? '' : ''; ?>">
                            <div class="<?php echo $idx % 2 === 1 ? 'lg:order-2' : ''; ?>">
                                <div class="aspect-[3/4] bg-[var(--bg-secondary)] rounded-[var(--card-radius)] overflow-hidden">
                                    <?php if (!empty($member['image']['url'])) : ?>
                                        <img src="<?php echo esc_url($member['image']['url']); ?>" alt="<?php echo esc_attr($member['name']); ?>" class="w-full h-full object-cover" />
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="<?php echo $idx % 2 === 1 ? 'lg:order-1' : ''; ?>">
                                <h3 class="text-3xl font-bold text-[var(--text-primary)] mb-1"><?php echo esc_html($member['name']); ?></h3>
                                <p class="text-lg text-[var(--primary)] font-medium mb-6"><?php echo esc_html($member['role']); ?></p>
                                <?php if (!empty($member['bio'])) : ?>
                                    <p class="text-[var(--text-secondary)] mb-6 leading-relaxed"><?php echo esc_html($member['bio']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($member['quote'])) : ?>
                                    <blockquote class="border-l-4 border-[var(--primary)] pl-4 italic text-[var(--text-secondary)]">
                                        "<?php echo esc_html($member['quote']); ?>"
                                    </blockquote>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        <?php
    }
}
