<?php
/**
 * Text Intro Highlight Widget
 * Текст с выделенным первым абзацем
 */

namespace AITheme\Elementor\Widgets;

use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Text_Intro_Highlight extends AI_Widget_Base {
    public function get_name() { return 'ai_text_intro_highlight'; }
    public function get_title() { return __('Text Intro Highlight', 'ai-theme'); }
    public function get_icon() { return 'eicon-text'; }
    public function get_categories() { return array('ai-theme-text'); }

    protected function register_controls() {
        $this->start_controls_section('content_section', ['label' => __('Content', 'ai-theme'), 'tab' => Controls_Manager::TAB_CONTENT]);
        
        $this->add_control('heading', ['label' => __('Heading', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('subheading', ['label' => __('Subheading (Label)', 'ai-theme'), 'type' => Controls_Manager::TEXT, 'default' => '']);
        $this->add_control('highlight_text', ['label' => __('Highlighted First Paragraph', 'ai-theme'), 'type' => Controls_Manager::TEXTAREA, 'default' => '']);
        $this->add_control('content', ['label' => __('Rest of Content', 'ai-theme'), 'type' => Controls_Manager::WYSIWYG, 'default' => '']);
        
        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $theme = get_option('ai_theme_style', 'modern');
        ?>
        <section class="py-16 md:py-20 section-light" data-theme="<?php echo esc_attr($theme); ?>" data-block-type="text" data-block-variant="text-intro-highlight">
            <div class="max-w-4xl mx-auto px-4 sm:px-6">
                <?php if (!empty($s['heading']) || !empty($s['subheading'])) : ?>
                <div class="mb-10 text-center">
                    <?php if (!empty($s['subheading'])) : ?>
                        <p class="text-sm font-medium text-[var(--primary)] uppercase tracking-wide mb-2"><?php echo esc_html($s['subheading']); ?></p>
                    <?php endif; ?>
                    <?php if (!empty($s['heading'])) : ?>
                        <h2 class="text-3xl md:text-4xl font-bold text-[var(--text-primary)]"><?php echo esc_html($s['heading']); ?></h2>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                <?php if (!empty($s['highlight_text'])) : ?>
                <p class="text-xl md:text-2xl text-[var(--text-primary)] leading-relaxed text-center mb-8 font-medium">
                    <?php echo esc_html($s['highlight_text']); ?>
                </p>
                <?php endif; ?>

                <?php if (!empty($s['content'])) : ?>
                <div class="space-y-4 max-w-3xl mx-auto text-center text-[var(--text-secondary)] leading-relaxed">
                    <?php echo wp_kses_post($s['content']); ?>
                </div>
                <?php endif; ?>
            </div>
        </section>
        <?php
    }
}
