<?php
/**
 * Lost Password Form Template
 *
 * Custom styled lost password form for AI Theme
 *
 * @package AI_Theme
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_lost_password_form');
?>

<div class="ai-login-page py-8 md:py-12" data-theme="<?php echo esc_attr(get_option('ai_theme_style', 'modern')); ?>">
    <div class="ai-container-narrow">

        <!-- Lost Password Form -->
        <div class="max-w-md mx-auto">
            <div class="bg-white rounded-2xl shadow-sm border border-gray-100 overflow-hidden">

                <!-- Header -->
                <div class="px-6 py-4 bg-gray-50 border-b border-gray-100 text-center">
                    <div class="w-16 h-16 bg-amber-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <svg class="w-8 h-8 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z"></path>
                        </svg>
                    </div>
                    <h2 class="text-xl font-semibold text-gray-900">
                        <?php echo esc_html(ai_get_text('account.forgotPasswordTitle', ai_get_label('account.forgot_password_title', ''))); ?>
                    </h2>
                    <p class="text-sm text-gray-500 mt-1">
                        <?php echo esc_html(ai_get_text('account.forgotPasswordSubtitle', ai_get_label('account.forgot_password_subtitle', ''))); ?>
                    </p>
                </div>

                <div class="p-6">
                    <form method="post" class="woocommerce-ResetPassword lost_reset_password">

                        <!-- Info message -->
                        <div class="mb-6 p-4 bg-blue-50 rounded-lg">
                            <p class="text-sm text-blue-700 flex items-start gap-2">
                                <svg class="w-5 h-5 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span><?php echo esc_html(ai_get_text('account.lostPasswordInfo', ai_get_label('account.lost_password_info', ''))); ?></span>
                            </p>
                        </div>

                        <!-- Email field -->
                        <div class="mb-6">
                            <label for="user_login" class="block text-sm font-medium text-gray-700 mb-2">
                                <?php echo esc_html(ai_get_text('account.emailOrUsername', ai_get_label('account.email_or_username', ''))); ?> <span class="text-red-500">*</span>
                            </label>
                            <div class="relative">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <svg class="w-5 h-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207"></path>
                                    </svg>
                                </div>
                                <input type="text" class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-primary focus:border-transparent transition-all" name="user_login" id="user_login" autocomplete="username" placeholder="<?php echo esc_attr(ai_get_text('account.enterEmail', ai_get_label('account.enter_email', ''))); ?>" required />
                            </div>
                        </div>

                        <?php do_action('woocommerce_lostpassword_form'); ?>

                        <input type="hidden" name="wc_reset_password" value="true" />
                        <?php wp_nonce_field('lost_password', 'woocommerce-lost-password-nonce'); ?>

                        <!-- Submit button -->
                        <button type="submit" class="w-full px-6 py-3 bg-primary text-white font-semibold rounded-lg hover:opacity-90 transition-opacity flex items-center justify-center gap-2" value="<?php esc_attr_e('Reset password', 'woocommerce'); ?>">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                            </svg>
                            <?php echo esc_html(ai_get_text('account.resetPasswordButton', ai_get_label('account.reset_password_button', ''))); ?>
                        </button>

                        <!-- Back to login link -->
                        <div class="mt-6 text-center">
                            <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="text-sm text-gray-500 hover:text-primary transition-colors flex items-center justify-center gap-2">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                                </svg>
                                <?php echo esc_html(ai_get_text('account.backToLogin', ai_get_label('account.back_to_login', ''))); ?>
                            </a>
                        </div>

                    </form>
                </div>
            </div>

            <!-- Help text -->
            <p class="text-center text-sm text-gray-500 mt-6">
                <?php echo esc_html(ai_get_text('account.rememberPassword', ai_get_label('account.remember_password', ''))); ?>
                <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>" class="text-primary hover:underline font-medium">
                    <?php echo esc_html(ai_get_text('account.loginButton', ai_get_label('account.login_button', ''))); ?>
                </a>
            </p>
        </div>

    </div>
</div>

<?php do_action('woocommerce_after_lost_password_form'); ?>
